'use client';

import { useState, useEffect } from 'react';
import Image from 'next/image';
import Link from 'next/link';
import { useTranslations, useLocale } from 'next-intl';
import Header from '../../components/Header';
import MobileHeader from '../../components/MobileHeader';
import Footer from '../../components/Footer';
import VillageInfrastructure from '../../components/VillageInfrastructure';
import PartnersSection from '../../components/PartnersSection';
import InvestmentReasons from '../../components/InvestmentReasons';
import AnimatedText from '../../components/AnimatedText';
import AnimatedImage from '../../components/AnimatedImage';
import AnimatedElement from '../../components/AnimatedElement';

export default function HomePage() {
  const [isDesktop, setIsDesktop] = useState(false);
  const t = useTranslations('HomePage');
  const tIntro = useTranslations('IntroSection');
  const tCommon = useTranslations('Common');
  const locale = useLocale();

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  const getLocalizedPath = (path: string) => {
    if (path === '/') {
        return `/${locale}`;
    }
    return `/${locale}${path}`;
  }

  if (isDesktop) {
    // Десктопная версия
  return (
    <div className="w-full min-h-screen bg-[#f5f1f0] flex flex-col">
        <Header />
      
        {/* Main Hero Section */}
        <section className="w-full h-[1080px] relative overflow-hidden flex flex-col justify-center items-center gap-2">
        <video 
          autoPlay
          loop
          muted
          playsInline
          controls={false}
          className="absolute top-0 left-0 w-full h-full object-cover"
          style={{ zIndex: 1 }}
        >
          <source src="/images/logo/doc_2025-07-08_01-30-02.mp4" type="video/mp4" />
        </video>
        
        <div className="relative w-[165px] h-[165px] flex-shrink-0" style={{ zIndex: 10 }}>
          <Image
            src="/images/logo/logotype1.svg"
            alt="LAKE Resort Residence"
            fill
            className="object-contain"
            priority
          />
        </div>
      </section>

        {/* First Insert Section */}
        <section className="w-full bg-white flex items-center justify-center px-8 py-[150px]">
        <div className="max-w-[1376px] w-full flex flex-col gap-10">
          <div className="flex flex-col gap-3">
            <AnimatedText
              as="h1"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {tIntro('title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
            >
              {tIntro('subtitle')}
            </AnimatedText>
          </div>
            <AnimatedElement animation="fadeIn" delay={600}>
              <Link href={getLocalizedPath('/lake-token')} className="w-[153px] h-[51px] bg-[#a79d94] rounded-sm flex items-center justify-center px-6 py-3 gap-2 hover:bg-[#9a8f86] transition-colors">
                <span className="text-white font-roboto text-lg font-normal leading-[150%]">
                  {tCommon('lake_token')}
                </span>
              </Link>
            </AnimatedElement>
        </div>
      </section>

        {/* Content Cards Section */}
      <section className="w-full bg-[#f5f1f0] py-[60px] flex flex-col items-center gap-10">
        
          {/* Card 1 */}
          <div className="max-w-[1440px] w-full px-8 flex flex-row items-center gap-10 h-[672px]">
            <AnimatedElement animation="slideInLeft" delay={200} className="flex-1 h-full">
              <video 
                autoPlay
                loop
                muted
                playsInline
                controls={false}
                className="w-full h-full object-cover"
              >
                <source src="/images/logo/Gen-4 Turbo animate sky ,grass and water only 3454623031.mp4" type="video/mp4" />
              </video>
            </AnimatedElement>
            <div className="flex-1 h-full flex flex-col justify-center gap-8">
              <div className="flex flex-col gap-4">
                <AnimatedText
                  as="h2"
                  animation="slideInUp"
                  delay={400}
                  className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
                >
                  {t('card1_title')}
                </AnimatedText>
                <div className="border-l border-[rgba(28,28,28,0.2)] pl-6 flex flex-col gap-4">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={600}
                    className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
                  >
                    {t('card1_text')}
                  </AnimatedText>
                </div>
              </div>
            </div>
          </div>

          {/* Card 2 */}
          <div className="max-w-[1440px] w-full px-8 flex flex-row items-center gap-10 h-[672px]">
            <div className="flex-1 h-full flex flex-col justify-center gap-8 order-1">
              <div className="flex flex-col gap-4">
                <AnimatedText
                  as="h2"
                  animation="slideInUp"
                  delay={200}
                  className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
                >
                  {t('card2_title')}
                </AnimatedText>
                <div className="border-l border-[rgba(28,28,28,0.2)] pl-6 flex flex-col gap-4">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={400}
                    className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
                  >
                    {t('card2_text')}
                  </AnimatedText>
                </div>
              </div>
            </div>
            <AnimatedElement animation="slideInRight" delay={600} className="flex-1 h-full order-2">
              <video 
                autoPlay
                loop
                muted
                playsInline
                controls={false}
                className="w-full h-full object-cover"
              >
                <source src="/images/logo/gen3-video.mp4" type="video/mp4" />
              </video>
            </AnimatedElement>
          </div>

          {/* Card 3 */}
          <div className="max-w-[1440px] w-full px-8 flex flex-row items-center gap-10 h-[672px]">
            <AnimatedElement animation="slideInLeft" delay={200} className="flex-1 h-full">
              <video 
                autoPlay
                loop
                muted
                playsInline
                controls={false}
                className="w-full h-full object-cover"
              >
                <source src="/images/logo/ГЛАВНАЯ_заменить_статику_и_ABOUT_справа.MP4" type="video/mp4" />
              </video>
            </AnimatedElement>
            <div className="flex-1 h-full flex flex-col justify-center gap-8">
              <div className="flex flex-col gap-4">
                <AnimatedText
                  as="h2"
                  animation="slideInUp"
                  delay={400}
                  className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
                >
                  {t('card3_title')}
                </AnimatedText>
                <div className="border-l border-[rgba(28,28,28,0.2)] pl-6 flex flex-col gap-4">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={600}
                    className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%]"
                  >
                    {t('card3_text')}
                  </AnimatedText>
                </div>
              </div>
            </div>
          </div>

      </section>

        {/* Second Insert Section */}
        <section className="w-full bg-white flex items-center justify-center px-8 py-[150px]">
        <div className="max-w-[1376px] w-full flex flex-col gap-10">
          <div className="flex flex-col gap-3">
            <AnimatedText
              as="h1"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('second_intro_title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
            >
              {t('second_intro_subtitle')}
            </AnimatedText>
          </div>
            <AnimatedElement animation="fadeIn" delay={600}>
              <Link href={getLocalizedPath('/lake-token')} className="w-[153px] h-[51px] bg-[#a79d94] rounded-sm flex items-center justify-center px-6 py-3 gap-2 hover:bg-[#9a8f86] transition-colors">
                <span className="text-[#f5f1f0] font-roboto text-lg font-normal leading-[150%]">
                  {tCommon('lake_token')}
                </span>
              </Link>
            </AnimatedElement>
          </div>
        </section>

        <VillageInfrastructure />
        <PartnersSection />
        <InvestmentReasons />
        
        {/* Final Insert Section */}
        <section className="w-full bg-white flex items-center justify-center px-8 py-[150px]">
          <div className="max-w-[1376px] w-full flex flex-col gap-10">
            <div className="flex flex-col gap-3">
              <AnimatedText
                as="h1"
                animation="slideInUp"
                delay={200}
                className="w-full text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
              >
                {t('final_intro_title')}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInUp"
                delay={400}
                className="w-full text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('final_intro_subtitle')}
              </AnimatedText>
            </div>
            <AnimatedElement animation="fadeIn" delay={600}>
              <Link href={getLocalizedPath('/lake-token')} className="w-[153px] h-[51px] bg-[#a79d94] rounded-sm flex items-center justify-center px-6 py-3 gap-2 hover:bg-[#9a8f86] transition-colors">
                <span className="text-[#f5f1f0] font-roboto text-lg font-normal leading-[150%]">
                  {tCommon('lake_token')}
                </span>
              </Link>
            </AnimatedElement>
          </div>
        </section>

        <Footer />
      </div>
    );
  }

  // Мобильная версия согласно JSON дизайну
  return (
    <div className="w-full min-h-screen bg-[#f5f1f0] flex flex-col overflow-hidden">
      <MobileHeader />
      
      {/* Main Hero Section - 700px высота согласно дизайну */}
      <section className="flex flex-col justify-center items-center gap-2 self-stretch h-[700px] bg-cover bg-center bg-no-repeat bg-gray-300 relative overflow-hidden">
        <video 
          autoPlay
          loop
          muted
          playsInline
          controls={false}
          className="absolute top-0 left-0 w-full h-full object-cover"
          style={{ zIndex: 1 }}
        >
          <source src="/images/logo/doc_2025-07-08_01-30-02.mp4" type="video/mp4" />
        </video>
        
        {/* Логотип 165x165 согласно дизайну */}
        <div className="relative w-[165px] h-[165px] flex-shrink-0 fill-white" style={{ zIndex: 10 }}>
          <Image
            src="/images/logo/logotype1.svg"
            alt="LAKE Resort Residence"
            fill
            className="object-contain"
            priority
          />
        </div>
      </section>

      {/* First Insert Section - 150px padding согласно дизайну */}
      <section className="flex justify-center items-center gap-10 self-stretch bg-white px-3 py-[150px]">
        <div className="flex flex-col items-start gap-10 flex-1">
          <div className="flex flex-col items-start gap-3 self-stretch">
            <AnimatedText
              as="h1"
              animation="slideInUp"
              delay={200}
              className="self-stretch text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {tIntro('title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="self-stretch text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
            >
              {tIntro('subtitle')}
            </AnimatedText>
          </div>
          <AnimatedElement animation="fadeIn" delay={600}>
            <Link href={getLocalizedPath('/lake-token')} className="flex justify-center items-center gap-2 self-stretch px-6 py-3 rounded-sm bg-[#a79d94] hover:bg-[#9a8f86] transition-colors">
              <span className="text-white font-roboto text-lg font-normal leading-[150%]">
                {tCommon('lake_token')}
              </span>
            </Link>
          </AnimatedElement>
        </div>
      </section>

      {/* Content Cards Section - 60px padding согласно дизайну */}
      <section className="flex flex-col justify-center items-center gap-10 self-stretch bg-[#f5f1f0] py-[60px]">
        
        {/* Card Container */}
        <div className="w-full flex flex-col items-center gap-10">
        
          {/* Card 1 */}
          <div className="w-full px-3 flex flex-col items-center gap-4">
            <AnimatedElement animation="slideInUp" delay={200} className="w-full h-[320px]">
              <video 
                autoPlay
                loop
                muted
                playsInline
                controls={false}
                className="w-full h-full object-cover"
              >
                <source src="/images/logo/Gen-4 Turbo animate sky ,grass and water only 3454623031.mp4" type="video/mp4" />
              </video>
            </AnimatedElement>
            <div className="w-full flex flex-col justify-center gap-4">
              <div className="flex flex-col gap-2">
                <AnimatedText
                  as="h2"
                  animation="slideInUp"
                  delay={400}
                  className="text-[#1c1c1c] font-roboto text-xl font-light leading-[130%]"
                >
                  {t('card1_title')}
                </AnimatedText>
                <div className="border-l border-[rgba(28,28,28,0.2)] pl-4">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={600}
                    className="text-[#1c1c1c] font-roboto text-base font-light leading-[150%] whitespace-pre-line"
                  >
                    {t('card1_text')}
                  </AnimatedText>
                </div>
              </div>
            </div>
          </div>

          {/* Card 2 */}
          <div className="w-full px-3 flex flex-col items-center gap-4">
            <div className="w-full h-[320px]">
              <AnimatedElement animation="slideInUp" delay={200} className="w-full h-full">
                <video 
                  autoPlay
                  loop
                  muted
                  playsInline
                  controls={false}
                  className="w-full h-full object-cover"
                >
                  <source src="/images/logo/gen3-video.mp4" type="video/mp4" />
                </video>
              </AnimatedElement>
            </div>
            <div className="w-full flex flex-col justify-center gap-4">
              <div className="flex flex-col gap-2">
                <AnimatedText
                  as="h2"
                  animation="slideInUp"
                  delay={400}
                  className="text-[#1c1c1c] font-roboto text-xl font-light leading-[130%]"
                >
                  {t('card2_title')}
                </AnimatedText>
                <div className="border-l border-[rgba(28,28,28,0.2)] pl-4">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={600}
                    className="text-[#1c1c1c] font-roboto text-base font-light leading-[150%] whitespace-pre-line"
                  >
                    {t('card2_text')}
                  </AnimatedText>
                </div>
              </div>
            </div>
          </div>

          {/* Card 3 */}
          <div className="w-full px-3 flex flex-col items-center gap-4">
            <AnimatedElement animation="slideInUp" delay={200} className="w-full h-[320px]">
              <video 
                autoPlay
                loop
                muted
                playsInline
                controls={false}
                className="w-full h-full object-cover"
              >
                <source src="/images/logo/ГЛАВНАЯ_заменить_статику_и_ABOUT_справа.MP4" type="video/mp4" />
              </video>
            </AnimatedElement>
            <div className="w-full flex flex-col justify-center gap-4">
              <div className="flex flex-col gap-2">
                <AnimatedText
                  as="h2"
                  animation="slideInUp"
                  delay={400}
                  className="text-[#1c1c1c] font-roboto text-xl font-light leading-[130%]"
                >
                  {t('card3_title')}
                </AnimatedText>
                <div className="border-l border-[rgba(28,28,28,0.2)] pl-4">
                  <AnimatedText
                    as="p"
                    animation="slideInUp"
                    delay={600}
                    className="text-[#1c1c1c] font-roboto text-base font-light leading-[150%]"
                  >
                    {t('card3_text')}
                  </AnimatedText>
                </div>
              </div>
            </div>
          </div>
          
        </div>

      </section>

      {/* Second Insert Section - 150px padding согласно дизайну */}
      <section className="flex justify-center items-center gap-10 self-stretch bg-white px-3 py-[150px]">
        <div className="flex flex-col items-start gap-10 flex-1">
          <div className="flex flex-col items-start gap-3 self-stretch">
            <AnimatedText
              as="h1"
              animation="slideInUp"
              delay={200}
              className="self-stretch text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('second_intro_title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="self-stretch text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
            >
              {t('second_intro_subtitle')}
            </AnimatedText>
          </div>
          <AnimatedElement animation="fadeIn" delay={600}>
            <Link href={getLocalizedPath('/lake-token')} className="flex justify-center items-center gap-2 self-stretch px-6 py-3 rounded-sm bg-[#a79d94] hover:bg-[#9a8f86] transition-colors">
              <span className="text-[#f5f1f0] font-roboto text-lg font-normal leading-[150%]">
                {tCommon('lake_token')}
              </span>
            </Link>
          </AnimatedElement>
        </div>
      </section>

      <VillageInfrastructure />
      <PartnersSection />
      <InvestmentReasons />
      
      {/* Final Insert Section - 150px padding согласно дизайну */}
      <section className="flex justify-center items-center gap-10 self-stretch bg-white px-3 py-[150px]">
        <div className="flex flex-col items-start gap-10 flex-1">
          <div className="flex flex-col items-start gap-3 self-stretch">
            <AnimatedText
              as="h1"
              animation="slideInUp"
              delay={200}
              className="self-stretch text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('final_intro_title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="self-stretch text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
            >
              {t('final_intro_subtitle')}
            </AnimatedText>
          </div>
          <AnimatedElement animation="fadeIn" delay={600}>
            <Link href={getLocalizedPath('/lake-token')} className="flex justify-center items-center gap-2 self-stretch px-6 py-3 rounded-sm bg-[#a79d94] hover:bg-[#9a8f86] transition-colors">
              <span className="text-[#f5f1f0] font-roboto text-lg font-normal leading-[150%]">
                {tCommon('lake_token')}
              </span>
            </Link>
          </AnimatedElement>
        </div>
      </section>

      <Footer />
    </div>
  );
} 